var language;
var i;
var j;
var k;
var xmlhttp;
var getParams;

var NUM_COLUMNS = 2;
var ON = 1;
var OFF = 0;

var gAlarmRows = [];
var gAlarmCnt = 0;
var alarm_data;

var ALARM_TABLE_NAME = new Array("gbe_alarm", "rf_alarm", "fan_alarm", "power_alarm", "other_alarm");
var alarmTypeNum = new Array(0,0,0,0,0);
var alarmTypeId = [];

function DisableApply()
{
	disabledButton(document.getElementById("Apply"), true);
}

function EnableApply()
{
	disabledButton(document.getElementById("Apply"), false);
}

function getElement(Event)
{
    var element;
    if(window.event)
    {
		element = window.event.srcElement;
    }
    else
    {
        element = Event.target;
    }
    return element;
}

function setAlarmSwitch(alarmId, value)
{
	if(value == ON)
	{
		document.getElementById(alarmId).checked = true;
	}
	else
	{
		document.getElementById(alarmId).checked = false;
	}
}

function getAlarmSwitch(alarmId)
{
	var alarmSwitch;
	if(document.getElementById(alarmId).checked == true)
	{
		alarmSwitch = ON;
	}
	else
	{
		alarmSwitch = OFF;
	}
	return alarmSwitch;
}

function clrAlarmAll()
{
	for(i = 0, j = ALARM_TABLE_NAME.length; i < j; i++)
	{
		document.getElementById(ALARM_TABLE_NAME[i]).style.display = "none";
		document.getElementById(ALARM_TABLE_NAME[i] + "_all").checked = false;
	}
}

function deleteAllRows()
{
	var table;
	var length;
	gAlarmRows = [];
	for(i = 0; i < 5; i++)
	{
		//talbe = document.getElementById(ALARM_TABLE_NAME[i]);
		length = document.getElementById(ALARM_TABLE_NAME[i]).rows.length;
		for(j = 1; j < length; j++)
		{
			document.getElementById(ALARM_TABLE_NAME[i]).deleteRow(alarmTypeNum[i]);
			alarmTypeNum[i]--;
			gAlarmCnt--; 
		}
	}
}

function alarmSwitchClick(Event)
{
	var obj = getElement(Event);
	var alarmSwitch = getAlarmSwitch(obj.id);
	var gIdx;	
	
	EnableApply();
	for(i = 0, j = alarmTypeId.length; i < j; i++)
	{
		if(obj.id == alarmTypeId[i])
		{
			gIdx = i;
			break;
		}
	}

	gAlarmRows[gIdx] = "M," + obj.id + "," + alarmSwitch;
}

function alarmSwitchChange(alarmId, index)
{
	var alarmSwitch = getAlarmSwitch(alarmId);	
	gAlarmRows[index] = "M," + alarmId + "," + alarmSwitch;
}

function UpdateRows(tableIdx, rowIdx, gIdx, sData)
{
	var cell;
	var newRow;
	
	var data = sData.split(",");
	var alarm_id = data[0];
	var alarm_txt = data[1];
	
	var sTable = document.getElementById(ALARM_TABLE_NAME[tableIdx]); 
	var row = sTable.rows[rowIdx + 1];	
	
	/*第一列插入复选框*/
	cell = row.cells[0];
	cell.innerHTML = "";
	var el = document.createElement("input");
	el.type = "checkbox";
	el.id = alarm_id;
	el.onclick = alarmSwitchClick;
	cell.appendChild(el);
	
	/*第二列插入告警类型描述*/
	cell = row.cells[1];
	cell.innerHTML = alarm_txt;
	
	newRow = "N," + alarm_id + ",0";
	gAlarmRows.push(newRow);
	alarmTypeId.push(alarm_id);
}

function addRow(tableIdx, rowNum)
{	
	var sTable = document.getElementById(ALARM_TABLE_NAME[tableIdx]);
	
	for(j = 0; j < rowNum; j++)
	{
		var row = sTable.insertRow(j + 1);

		for(k = 0; k < NUM_COLUMNS; k++)
		{
			var cell = row.insertCell(k);
		}
		
		gAlarmCnt++;
		UpdateRows(tableIdx, j, gAlarmCnt, alarm_data[j + 1]);
	}
}

function getAlarmType()
{
	var response;
	var alarm_array;
	var table;
	var flag;
	var exist_status;
	var len;

	xmlhttp = getHTTPObject();
	getParams = "type=39&cmd=1&language=" + language + "&getAlarmType=1";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			
			alarm_array = response.split("|");
			
			for(i = 0, len = alarm_array.length; i < len; i++)
			{
				alarm_data = alarm_array[i].split("&");
				flag = alarm_data[0].split(",");
				
				var tableIdx = flag[0] - 1;
				table = document.getElementById(ALARM_TABLE_NAME[tableIdx]);
				exist_status = flag[1];
				alarmTypeNum[tableIdx] = flag[2];
				
				if(exist_status == 1)
				{
					table.style.display = "";
					addRow(i, alarmTypeNum[tableIdx]);
				}
			}
			
			GetAlarmShield();
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

function displayAlarmSwitch(response_array)
{
	var data;
	var len = response_array.length;
	
	for(i = 0; i < len; i++)
	{
		data = response_array[i].split(",");
		for(j = 0, k = alarmTypeId.length; j < k; j++)
		{
			if(data[0] == alarmTypeId[j])
			{
				setAlarmSwitch(data[0], data[1]);
			}
		}
	}
}

function GetAlarmShield()
{
	var response;
	var response_array;
	xmlhttp = getHTTPObject();
	getParams = "type=39&cmd=1&getAlarmShield=112233";
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, - bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			
			response_array = response.split("&");
			displayAlarmSwitch(response_array);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function PageLoadHandler()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	clrAlarmAll();
	getAlarmType();
	
	document.body.style.cursor = "auto";
	window.status = "Done";
}

function pageRefresh()
{
	deleteAllRows();
	PageLoadHandler();
}

window.onload = function()
{
	language = document.getElementById("language").value;
	PageLoadHandler();
	var apply = document.getElementById("Apply");
	applyDispay(parent.group, apply);
}

function setAll(obj, typeNum)
{
	var alarm_id;
	var gIdx = 0;
	var index;	
	
	for(i = 0; i < typeNum; i++)
	{
		gIdx += parseInt(alarmTypeNum[i]);
	}
	
	EnableApply();
	if(obj.checked == true)
	{
		for(i = 0; i < alarmTypeNum[typeNum]; i++)
		{
			index = gIdx + i;
			alarm_id = alarmTypeId[index];
			setAlarmSwitch(alarm_id, ON);
			alarmSwitchChange(alarm_id, index);
		}
	}
	else
	{
		for(i = 0; i < alarmTypeNum[typeNum]; i++)
		{
			index = gIdx + i;
			alarm_id = alarmTypeId[index];
			setAlarmSwitch(alarm_id, OFF);
			alarmSwitchChange(alarm_id, index);
		}
	}
}

function generateAlarmParam()
{
	var data;
	var param = "";
	
	for(i = 0; i < gAlarmCnt; i++)
	{
		if(gAlarmRows[i].slice(0,1) == "M")
		{
			data = gAlarmRows[i].split(",");
			param += "&" + data[1] + "=" + data[2];
		}
	}

	return param;
}

function postAlarmSwitchData()
{
	getParams = "type=39&cmd=2" + generateAlarmParam();
	
	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("Alarm shield configuration updated successfully.");
			}
			else
			{
				alert("告警屏蔽参数已设置成功。");
			}
			pageRefresh();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function SetAlarmShieldConfig()
{
	DisableApply();
	document.body.style.cursor = "wait";
	window.status = "Updating alarm shield information, please wait...";
	postAlarmSwitchData();		
}